package fiw.core.option;

/**
 * A validator that allows only a few distinct String values.
 * @author mihi
 */
public class ChoiceOptionType extends OptionType {
    private String[] choices;
    private String[] choiceNames;
    private String error;

    /**
     * Creates a ChoiceValidator with the given list of choices. When setting
     * a string that is not in this array, "Invalid value" is returned as
     * error message.
     * @param choices all allowed choices
     */
    public ChoiceOptionType(String[] choices, String[] choiceNames) {
	this(choices,choiceNames, "Invalid value");
    }

    /**
     * Creates a ChoiceValidator with the given list of choices.
     * @param choices all allowed choices
     * @param error the error message when another string should be set.
     */    
    public ChoiceOptionType(String[] choices, String[] choiceNames,
			    String error) {
	this.choices=choices;
	this.choiceNames = choiceNames;
	this.error=error;
    }

    /**
     * Returns the reason why a String is invalid.
     */
    public String getInvalidReason(String s) {
	if (s==null) return error;
	for (int i=0;i<choices.length;i++) {
	    if (s.equals(choices[i])) return null;
	}
	return error;
    }

    public String[][] getChoices() {
	return new String[][] {choiceNames, choices};
    }
}
