package fiw.core.option;

/**
 * An option that can be "executed" and should therefore be shown as a button.
 * @author mihi
 */ 
public abstract class ButtonOption extends Option {

    private boolean grouped;

    public ButtonOption(String title, int panel, boolean grouped) {
	super(title,20, panel);
	this.grouped=grouped;
    }

    public ButtonOption(String title, int panel, boolean grouped, Enabler en) {
	super(title,20, panel, en);
	this.grouped=grouped;
    }

    public boolean isGroupedWithPrevious() {
	return grouped;
    }    

    public abstract void handleAction();
    public abstract Option[] getAffectedOptions();
}
