package fiw.core.option;

/**
 * A Container for multiple options that somehow belong together.
 * @author mihi
 */
public abstract class AbstractOptions {

    /** the option type used for global boolean options */
    public static final OptionType BOOL = new BooleanOptionType();

    /**
     * Returns the list of options.
     * @return an array with all options.
     */
    public abstract Option[] getSettings();

    /**
     * Loads all options from the config file.
     */
    public abstract void load();

    /**
     * Saves all modified options to the config file.
     */
    public  abstract void save();

    /**
     * Gets an option by its property name.
     * @param property the property name
     * @return the option using this property name
     */
    public Option getOption(String property) {
	if (property == null) return null;
	Option[] settings = getSettings();
	for (int i=0;i<settings.length;i++) {
	    if (property.equals(settings[i].getProperty())) {
		return settings[i];
	    }
	}
	return null;
    }		   
}
