package fiw.core.jobs;

/**
 * A class implementing that interface can produce threads to run jobs.
 * This class may use thread pooling or not.
 * @author mihi
 */
public interface ThreadProducer {

    /**
     * Does anything needed before threads can be produced.
     */
    public void initialize();

    /**
     * Produces a thread for a job to run. This method may block until
     * such a thread is available.
     * @param j the job to run
     */
    public void produceThread(Job j);

    /**
     * Cleans up any resources that are still used.
     */
    public void finish();
}
