package fiw.core.jobs;

import fiw.core.insert.*;
import fiw.fcp.*;

/**
 * Builds matadata for a FEC splitfile.
 * @author mihi
 */
public class SplitfileBuilderJob extends Job implements MetadataProducing {

    private InsertContext ic;
    private FCPConnection fc;
    private String filename, ctype, metadata;
    private long filelen;

    /**
     * Creates a new splitfile builder job.
     * @param filelen the length of the file
     * @param filename the name of the file
     * @param ctype the content type of the file
     * @param ic the insert context
     * @param dependencies the jobs this job depends on
     */
    public SplitfileBuilderJob(long filelen, String filename, String ctype,
			       InsertContext ic, Job[] dependencies) {
	super(true, dependencies, "Splitfile builder for "+filename);
	this.filename=filename;
	this.ctype=ctype;
	this.filelen=filelen;
	this.ic=ic;
	fc=ic.getFCPConnection();
    }
    
    /**
     * Runs the job.
     */
    public int run() {
	Job[] deps = getDependencies();
	String sha1 = ((FECBuilderJob)deps[0]).getSHA1();
	String[] blocks = new String[deps.length-1];
	for (int i=1;i<deps.length;i++){
	    blocks[i-1] = ((FilePartInsertJob)deps[i]).getResultKey();
	}
	if (sha1==null) {
	    throw new RuntimeException("assert failed: sha1 != null");
	}
	FECConnection encoder=fc.getFECInstance();
	try {
	    if (encoder==null) {
		ic.addlog("#"+ic.num(myNumber)+
			  " Waiting until FEC encoder is free..");
		encoder=fc.waitForFECInstance();
	    }
	    metadata = encoder.makeSplitfile
		(filelen, blocks, (String)ctype, sha1);
	    if (metadata == null) {
		ic.addlog("[ERROR] Cannot generate splitfile for "+
			  filename+" ***************");
		return 2;
	    }
	} finally {
	    if (encoder !=null) {
		encoder.releaseInstance();
	    }
	}
	return 0;
    }

    /**
     * Returns the new splitfile.
     */
    public String produceMetadata() {
	if (!metadata.startsWith("Version\nRevision=1\n") ||
	    !metadata.endsWith("End\n")) {
	    return null;
	}
	String metadata2 = metadata.substring(19, metadata.length()-4);
	return metadata2;
    }
}
