package fiw.core.jobs;
import fiw.core.insert.*;

/**
 * Inserts a FEC splitfile.
 */
public class SplitFileInsertJob extends MetadataInsertJob
    implements MetadataProducingEx {

    private boolean isDefault;
    private String ctype, filename;

    /**
     * Creates a new splitfile insert job.
     * @param key the key to insert it to
     * @param filename the name of the splitfile
     * @param ctype the content type of the splitfile
     * @param isDefault whether this is the default file
     * @param ic the insert context
     * @param deps the jobs this job depends on
     */
    public SplitFileInsertJob(String key, String filename, String ctype,
			      boolean isDefault,
			      InsertContext ic, Job[] deps) {
	super(key, null, "Splitfile for "+filename,
	      ic,deps);
	this.ctype=ctype;
	this.filename=filename;
	this.isDefault=isDefault;
    }

    // shouldRun() and run() like in MetadataInsertJob

    /**
     * Returns a redirect to the splitfile.
     */
    public String produceMetadata () {
	if (!isDefault) {
	    return "";
	}
	return "EndPart\nDocument\n"+
            "Redirect.Target=freenet:"+getResultKey()+
	    "\nInfo.Format="+ctype+"\n";
    }

    /**
     * Returns a redirect to the splitfile to be used in mapfiles.
     */
    public String produceMetadataEx() {
	return "EndPart\nDocument\nRedirect.Target=freenet:"+
	    getResultKey()+"\nName="+
	    filename+"\nInfo.Format="+ctype+"\n";	
    }
}
