package fiw.core.jobs;

/**
 * A simple thread producer that creates a new thread for each job to
 * run.
 * @author mihi
 */
public class SimpleThreadProducer implements ThreadProducer {

    /**
     * Does nothing.
     */
    public void initialize() {}

    /**
     * Creates a new thread and runs the job in it.
     * @param j the job to run
     */
    public void produceThread(final Job j) {
	Thread t= new Thread(new Runnable() {
		public void run() {
		    j.run0();
		}
	    });
	t.start();
    }
    
    /**
     * Does nothing.
     */
    public void finish() {}
}
