package fiw.core.jobs;

import fiw.core.*;

/**
 * This job scheduler reorders jobs if the next job is blocked but
 * there is still an unblocked job available.
 */
public class ReorderingJobScheduler extends DefaultJobScheduler {

    private int minNumberToTest=0;
    private boolean[] started;

    /**
     * Creates a new reordering job scheduler.
     * @param jobs the jobs to schedule.
     * @param maxThreads the maximal number of threads to use
     * @param l a logger to log errors
     * @param tp the ThreadProducer instance to use for threaded jobs
     */
    public ReorderingJobScheduler(Job[] jobs, int maxThreads, MyLogger l,
				  ThreadProducer tp) {
	super(jobs, maxThreads, l, tp);
	started=new boolean[jobs.length];
    }

    /**
     * Returns the next job to be scheduled. The job returned must be
     * ready to run.
     * @return the index of the next job in the jobs array
     */
    protected int getNextJob() throws InterruptedException {
	synchronized(syncJobs) {
	    outer:
	    while (minNumberToTest < jobs.length) {
		while (started[minNumberToTest]) {
		    minNumberToTest++;
		    if (minNumberToTest == jobs.length) break outer;
		}
		for (int i=minNumberToTest;i<jobs.length;i++) {
		    if (!started[i] && jobs[i].isReadyToRun()) {
			started[i]=true;
			return i;
		    }
		}
		syncJobs.wait();
	    }
	}
	return -1;
    }   
}
