package fiw.core.jobs;

/**
 * Implemented by Jobs that can produce metadata for other jobs. The
 * metadata for simple MetadataJobs and the one for MapfileBuilderJobs
 * may be different (e.g. inserting of files, splitfiles).
 */
public interface MetadataProducingEx extends MetadataProducing {
    /**
     * Returns a string of metadata, containing the starting
     * <tt>"EndPart\n"</tt> but not containing the trailing
     * <tt>"End\n"</tt>. So an empty string will lead to the usual
     * "Version/Revision/End" metadata. This metadata is used for
     * mapfiles additionally to that provided by
     * {@link #produceMetadata()}.
     */
    public String produceMetadataEx();
}
