package fiw.core.jobs;

/**
 * Implemented by Jobs that can produce a "mask" of metadata for other
 * jobs.
 */
public interface MetadataMaskProducing {
    /**
     * Returns a string of metadata, containing the starting
     * <tt>"EndPart\n"</tt> but not containing the trailing
     * <tt>"End\n"</tt>. So an empty string will lead to the usual
     * "Version/Revision/End" metadata. This String contains "#"
     * tokens that will be replaced by a CHK key later.
     */
    public String produceMetadataMask();
}
