package fiw.core.jobs;
import fiw.core.insert.*;

/**
 * A job that replaces # characters from a metadata mask by the result
 * key of an insert job.
 * @author mihi
 */
public class MetadataMaskFillerJob extends Job implements MetadataProducing {
    private InsertContext ic;
    private String metadata = null;
    private MetadataMaskProducing maskproducer;
    private InsertJob inserter;


    /**
     * Creates a new metadata mask filler job.
     * @param maskproducer the job that produces the mask
     * @param inserter the process that knows the key
     * @param ic the insert context
     * @param dependencies the jobs this job depends on
     */
    public MetadataMaskFillerJob(MetadataMaskProducing maskproducer,
				 InsertJob inserter,
				 InsertContext ic, Job[] dependencies) {
	super(false, dependencies,  "format metadata");
	this.maskproducer = maskproducer;
	this.inserter =inserter;
	this.ic=ic;
    }

    /**
     * Runs the job.
     */
    public int run () {
	ic.addlog("#"+ic.num(myNumber)+" Formatting metadata");
	String base = maskproducer.produceMetadataMask();
	String key = "freenet:"+inserter.getResultKey();
	StringBuffer b = new StringBuffer(base.length()*2);
	int pos;
	while ((pos = base.indexOf("#")) != -1) {
	    b.append(base.substring(0, pos)).append(key);
	    base=base.substring(pos+1);
	}
	b.append(base);
	metadata=b.toString();
	ic.addlog("#"+ic.num(myNumber)+" Metadata formatted");
	return 0;
    }

    /**
     * Returns the metadata after the replacements
     */
    public String produceMetadata() {
	return metadata;
    }
}
