package fiw.core.jobs;

import fiw.core.*;
import fiw.core.insert.*;

/**
 * Inserts metadata into Freenet.
 * @author mihi
 */
public class MetadataInsertJob extends InsertJob {

    private String key;
    private boolean metadataNull;

    /**
     * Creates a new metadata insert job.
     * @param key the key to insert into
     * @param metadata the metadata to insert
     * @param name a name for the metadata
     * @param ic the insert context
     * @param dependencies the jobs this job depends on
     */
    public MetadataInsertJob(String key, String metadata,
			     String name,
			     InsertContext ic,
			     Job[] dependencies) {
	super(key, metadata, new NullStreamBuilder(),0,
	      name, makeProgressName(key, metadata), ic, dependencies);
	metadataNull = (metadata == null);
	this.key=key;
    }

    private static String makeProgressName(String key, String metadata) {
	return HashUtil.calcMD5(metadata+key);
    }

    /**
     * Checks if this metadata must be inserted.
     */
    public boolean shouldRun() {
	if (metadataNull) {
	    Job dep = getDependency();
	    if (dep instanceof MetadataProducing) {
		metadataNull = false;
		String newMetadata = "Version\nRevision=1\n"+
		    ((MetadataProducing)dep).produceMetadata()+
		    "End\n";
		setMetadata(newMetadata);
		setProgressName("Metadata."+
				makeProgressName(key, newMetadata));
	    }
	}
	return super.shouldRun();
    }
}
