package fiw.core.jobs;
import fiw.core.insert.*;

/**
 * A job that builds a manifest file (mapfile) for a freesite.
 * @author mihi
 */
public class MapfileBuilderJob extends Job implements MetadataProducing {
    private InsertContext ic;
    private String metadata = null, extra;

    /**
     * Creates a new mapfile builder job.
     * @param extra an extra text to place into the mapfile
     * @param ic the insert context
     * @param dependencies jobs this job depends on
     */
    public MapfileBuilderJob(String extra, InsertContext ic,
			     Job[] dependencies) {
	super(false, dependencies,  "collect metadata");
	this.ic=ic;
	this.extra=extra;
    }

    /**
     * Runs the job.
     */
    public int run () {
	ic.addlog("#"+ic.num(myNumber)+" Generating mapfile");
	Job[] deps = getDependencies();
	StringBuffer b = new StringBuffer();
	StringBuffer mainEntries = new StringBuffer();
	for (int i=0;i<deps.length;i++) {
	    if (deps[i] instanceof MetadataProducingEx) {
		MetadataProducingEx j = (MetadataProducingEx) deps[i];
		b.append(j.produceMetadataEx());
		mainEntries.append(j.produceMetadata());
	    } else if (deps[i] instanceof MetadataProducing) {
		MetadataProducing j = (MetadataProducing) deps[i];
		b.append(j.produceMetadata());
	    }
	}
	b.append(extra);
	b.append(mainEntries.toString());
	metadata = b.toString();
	ic.addlog("#"+ic.num(myNumber)+" Mapfile generated");
	return 0;
    }

    /**
     * Produces the manifest file.
     */
    public String produceMetadata() {
	return metadata;
    }
}
