package fiw.core.jobs;

import fiw.core.insert.*;

/**
 * This job inserts an indirect mapfile and returns a redirect to it
 * to be put into the "real" mapfile.
 * @author mihi
 */
public class IndirectMapfileInsertJob extends MetadataInsertJob
    implements MetadataProducing {

    private InsertContext ic;
    private boolean giveNoise;
    private String myMetadata = null;

    /**
     * Creates a new indirect mapfile insert job.
     * @param ic the insert context
     * @param giveNoise whether to log a message that an indirect
     * mapfile is needed
     * @param dependencies jobs this job depends on
     */
    public IndirectMapfileInsertJob(InsertContext ic, boolean giveNoise,
				    Job[] dependencies) {
	super("CHK@", null, "indirect mapfile",ic, dependencies);
	this.ic=ic;
	this.giveNoise=giveNoise;
    }

    /**
     * Checks whether an indirect mapfile is necessary
     */
    public boolean shouldRun() {
	Job dep = getDependency();
	if (!(dep instanceof MetadataProducing)) {
	    throw new RuntimeException
		("assert: indirect mapfile gets metadata");
	}
	myMetadata = ((MetadataProducing)dep).produceMetadata();
	if (giveNoise) {
	    ic.addlog("#"+ic.num(myNumber)+" Mapfile size: "+
		      myMetadata.length() +" bytes.");
	}
	if (myMetadata.length() < 32500) { // no indirect mapfile
	    resultKey="!none!";
	    return false;
	} else {
	    if (giveNoise) {
		ic.addlog("#"+ic.num(myNumber)+" Mapfile exceeds 32K limit.");
	    }
	    myMetadata = null;
	    return super.shouldRun();
	}
    }
    
    /**
     * Returns the redirect to this indirect mapfile - or the mapfile
     * itself, if it is small enough.
     */
    public String produceMetadata() {
	if (myMetadata != null) {
	    return myMetadata;
	} else {
	    return "EndPart\nDocument\nRedirect.Target=freenet:"+
		getResultKey()+"\n";
	}
    }
}
