package fiw.core.jobs;
import fiw.core.insert.*;

import fiw.core.HashUtil;
import java.io.*;

/**
 * Calculates both SHA1 and MD5 hash of a file
 */
public class HashCalcJobEx extends Job implements HashProducing {
    private String hash = null, sha1=null;
    private InsertContext ic;
    private File f;

    /**
     * Creates a new hash calc job.
     * @param f the file to calculate the hashes from
     * @param name the name of that file
     * @param ic the insert context
     * @param dependencies jobs this jobs depends on
     */
    public HashCalcJobEx(File f, String name, InsertContext ic,
			 Job[] dependencies) {
	super(false, dependencies,  HashUtil.hashCipher()+"/SHA1 for "+name);
	this.f=f;
	this.ic=ic;
    }

    /**
     * Runs the job.
     */
    public int run () {
	ic.addlog("#"+ic.num(myNumber)+" Calculating "+this);
	String[] md5nSHA1 = HashUtil.calcMD5andSHA1(f);
	hash = md5nSHA1[0];
	sha1 = md5nSHA1[1];
	ic.addlog("#"+ic.num(myNumber)+" Done "+this);
	return 0;
    }

    /**
     * Returns the MD5 hash.
     */
    public String produceHash() {
	return hash;
    }

    /**
     * Returns the SHA1 hash.
     */
    public String getSHA1() {
	return sha1;
    }
}
