package fiw.core.jobs;
import fiw.core.insert.*;
import fiw.core.HashUtil;
import java.io.*;

/**
 * This job calculates the MD5 hash of a file.
 * @author mihi
 */
public class HashCalcJob extends Job implements HashProducing {
    private String hash = null;
    private InsertContext ic;
    private File f;

    /**
     * Creates a new HashCalcJob.
     * @param f the file to calculate the hash of
     * @param name the name of that file
     * @param ic the insert context
     * @param dependencies jobs this jobs depends on
     */
    public HashCalcJob(File f, String name, InsertContext ic,
		       Job[] dependencies) {
	super(false, dependencies,  HashUtil.hashCipher()+" for "+name);
	this.f=f;
	this.ic=ic;
    }

    /**
     * Runs the job.
     */
    public int run () {
	ic.addlog("#"+ic.num(myNumber)+" Calculating "+this);
	hash = HashUtil.calcMD5(f);
	ic.addlog("#"+ic.num(myNumber)+" Done "+this);
	return 0;
    }

    /**
     * Returns the calculated hash.
     */
    public String produceHash() {
	return hash;
    }
}
