package fiw.core.jobs;
import fiw.core.insert.*;
import fiw.core.insert.event.*;

/**
 * A job that just shows a message.
 * @author mihi
 */
public class DummyJob extends Job {
    private String logtext;
    private InsertContext ic;

    /**
     * Creates a new dummy job.
     * @param logtext the message to log
     * @param ic the insert context
     * @param dependencies the jobs this job depends on
     */
    public DummyJob(String logtext, InsertContext ic, Job[] dependencies) {
	super(false, dependencies, "Dummy job");
	this.logtext=logtext;
	this.ic=ic;
    }
    
    /**
     * Runs the job.
     */
    public int run () {
	if (ic != null) {
	    ic.fireInsertEvent(new SeparatorInsertEvent(logtext, myNumber));
	}
	return 0;
    }
}
