package fiw.core.jobs;

import fiw.core.insert.*;

/**
 * This job inserts a date based redirect.
 * @author mihi
 */
public class DBRInsertJob extends MetadataInsertJob {

    /**
     * Creates a new DBRInsertJob.
     * @param key the (secret) key to insert the DBR into
     * @param increment the <code>DateRedirect.Increment</code> to use
     * @param offset the <code>DateRedirect.Offset</code> to use
     * @param pubkey the public key to redirect to
     * @param ic the insert context
     * @param dependencies jobs this job depends on
     */
    public DBRInsertJob(String key, int increment,
			int offset, String pubkey,
			InsertContext ic,
			Job[] dependencies) {
	super(key, makeDBRMetadata(increment, offset, pubkey), "DBR",
	      ic, dependencies);
    }

    /**
     * Creates the metadata for a DBR.
     * @param increment the <code>DateRedirect.Increment</code> to use
     * @param offset the <code>DateRedirect.Offset</code> to use
     * @param pubkey the public key to redirect to
     * @return the DBR metadata
     */
    private static String makeDBRMetadata(int increment,
					 int offset,
					 String pubkey) {
	String dbrmeta="Version\nRevision=1\nEndPart\nDocument\n"+
	    (increment!=86400?"DateRedirect.Increment="+
	     Integer.toHexString(increment)+"\n":"")+
	    (offset!=0?"DateRedirect.Offset="+
	     Integer.toHexString(offset)+"\n":"")+
	    "DateRedirect.Target="+pubkey+
	    "\nEnd\n";
	return dbrmeta;
    }
}
