package fiw.core.jobs;

import fiw.core.insert.*;
import fiw.core.*;

import java.util.zip.*;
import java.io.*;
import java.util.*;

/**
 * This job builds a "Container" - a zipfile containing multiple files.
 * @author mihi
 */
public class ContainerBuilderJob extends Job implements MetadataMaskProducing {

    private InsertContext ic;
    private FreenetContainer cont;
    private ContentTypeManager ctm;
    private String metadataMask = null;

    /**
     * Creates a new ContainerBuilderJob.
     * @param cont the container to build
     * @param ctm a content type manager used to determine content
     * types of files
     * @param ic the insert context
     * @param dependencies jobs this job depends on
     */
    public ContainerBuilderJob(FreenetContainer cont,
			       ContentTypeManager ctm,
			       InsertContext ic, Job[] dependencies) {
	super(false, dependencies, "Building container "+cont.getName());
	this.cont=cont;
	this.ic=ic;
	this.ctm=ctm;
    }

    /**
     * Runs the job.
     */
    public int run() {
	List fls = cont.getFiles();
	StringBuffer mdInside=new StringBuffer(),
	    md = new StringBuffer();
	mdInside.append("Version\nRevision=1\n");
	for (Iterator i = fls.iterator(); i.hasNext();) {
	    SubFile fl = (SubFile)i.next();
	    String common="Name="+fl.getSubName()+"\nInfo.Format="+
		ctm.getCType(fl.getSubName())+"\n";
	    mdInside.append("EndPart\nDocument\n").append(common);
	    md.append("EndPart\nDocument\n").append("Redirect.Target=#//")
		.append(fl.getSubName()).append("\n").append(common);
	    if (fl.getSubName().equals("index.html")) {
		md.append("EndPart\nDocument\n").append("Redirect.Target=#//")
		    .append(fl.getSubName()).append("\nInfo.Format=")
		    .append(ctm.getCType(fl.getSubName())).append("\n");
	    }
	}
	mdInside.append("End\n");
	metadataMask = md.toString();
	ic.addlog("#"+ic.num(myNumber)+" Building container "+cont.getName());
	byte[] bs = new byte[8192];
	int length;
	try {
	    ZipOutputStream zos = new ZipOutputStream
		(new FileOutputStream(cont.getContainerFile()));
	    zos.setLevel(9);
	    ZipEntry ze=new ZipEntry("manifest");
	    ze.setTime(0); // unix epoch
	    zos.putNextEntry(ze);
	    zos.write(mdInside.toString().getBytes("ISO-8859-1"));
	    zos.closeEntry();
	    for (Iterator i = fls.iterator(); i.hasNext();) {
		SubFile fl = (SubFile) i.next();

		ze=new ZipEntry(fl.getSubName());
		ze.setTime(0);
		zos.putNextEntry(ze);
		InputStream bis=new FileInputStream(fl);
		while ((length = bis.read(bs)) != -1) {
		    zos.write(bs,0,length);
		}
		bis.close();
		zos.closeEntry();
	    }
	    zos.finish();
	    zos.close();
	    long filelength = cont.getContainerFile().length();
	    if (filelength >= ic.FECMINSIZE) {
		ic.addlog("#"+ic.num(myNumber)+" [Error] Container is too "+
			  "large ("+filelength+" bytes): "+ cont.getName());
		ic.setRetryFutile();
		return 3;
	    }
	    ic.addlog("#"+ic.num(myNumber)+" Finished building container "+
		      cont.getName());
	    return 0;
	} catch (IOException ex) {
	    ex.printStackTrace();
	    ex.printStackTrace(FIWSystem.log());
	    ic.addlog("#"+ic.num(myNumber)+" [Error] Unexpected error - "+
		      "consult logfile");
	    ic.setRetryFutile();
	    return 3;
	}
    }

    /**
     * Returns a "masked" metadata - all "#" chars have to be replaced
     * by the CHK of the container.
     */
    public String produceMetadataMask() {
	return metadataMask;
    }

}
