package fiw.core.jobs;
import fiw.core.insert.*;

/**
 * A job that controls whether a "fallback" key is inserted when
 * another key insert collides. Add dependencies to all jobs that
 * should be checked - if any of these produces a KeyCollision, jobs
 * depending on this jobs are run - otherwise they are not run.
 * @author mihi
 */
public class CollisionFallbackJob extends Job implements MetadataProducing {

    private InsertContext ic;
    private MetadataProducing mapfile;

    /**
     * Creates a new CollisionFallbackJob.
     * @param mapfile The job that is asked for metadata.
     * @param ic the insert context.
     * @param dependencies {@link InsertJob}s to be checked.
     */
    public CollisionFallbackJob(MetadataProducing mapfile, InsertContext ic,
				Job[] dependencies) {
	super(false, dependencies,  "collision fallback");
	this.ic=ic;
	this.mapfile=mapfile;
	for (int i=0;i<dependencies.length;i++) {
	    ((InsertJob)dependencies[i]).setKeyCollisionOkay();
	}
    }

    /**
     * Runs the job.
     */
    public int run () {	
	Job[] deps = getDependencies();
	boolean coll = false;
	for (int i=0;i<deps.length;i++) {
	    if (((InsertJob)deps[i]).isKeyCollision()) {
		coll = true;
		break;
	    }
	}
	if (!coll) {
	    return 1; // do not insert fallback key
	}
	ic.addlog("#"+ic.num(myNumber)+" At least one mapfile could not "+
		  "be inserted.");
	return 0;
    }

    /**
     * Gets the metadata from the given job.
     * @return the metadata
     */
    public String produceMetadata() {
	String metadata = mapfile.produceMetadata();
	if (metadata == null) {
	    ic.addlog("[Error] No metadata available for fallback key");
	}
	return metadata;
    }
}
