package fiw.core.insert.event;

/**
 * Represents a job which has successfully inserted (uploaded) data.
 */
public class UploadedJobInsertEvent extends StructuredJobInsertEvent {

    protected String key;
    
    public UploadedJobInsertEvent(int jobNumber, int retry, boolean found,
				    String desc, String key) {
	super(jobNumber, retry,
	      found ? "+++Found   " : "...Upped   ",
	      desc);
	this.key=key;
    }


    public String toLogString() {
	return makeLogString(retry, action, desc)+"\n"+
	    makeLogString(-2, "Key is        ", key);
    }

    public String getKey() {
	return key;
    }
}
