package fiw.core.insert.event;

/**
 * Actions that make up that nice tables in the log.
 */
public class StructuredJobInsertEvent extends AbstractJobInsertEvent {

    protected String action, desc;
    protected int jobNumber, retry;
    private boolean important, logIt;
    
    public StructuredJobInsertEvent(int jobNumber, int retry,
				    String action, String desc) {
	this(jobNumber, retry, action, desc, false, true);
    }

    public StructuredJobInsertEvent(int jobNumber, int retry,
				    String action, String desc,
				    boolean important, boolean logIt) {    
	super(jobNumber);
	this.retry=retry;
	this.action=action;
	this.desc=desc;
	this.important=important;
	this.logIt=logIt;
    }

    public String toLogString() {
	return logIt ? makeLogString(retry, action, desc) : null;
    }

    public String toJobLogString() {
	return important ? makeJobLogString(retry, action, desc) : null;
    }
}
