package fiw.core.insert.event;

/**
 * InsertEvent fired between different parts of the insert progress.
 * Shows a separator both in the log and in the thread window.
 */
public class SeparatorInsertEvent extends InfoInsertEvent {

    private int jobnumber;
    
    public SeparatorInsertEvent(String infoString, int jobnumber) {
	super(infoString);
	this.jobnumber=jobnumber;
    }

    public int getJobNumber() {
	return jobnumber;
    }

    public int getJobStateChange() {
	return JOB_STATE_STARTSTOP;
    }

    public String toJobLogString() {
	return "-------------------------";
    }
}
