package fiw.core.insert.event;
import fiw.core.insert.*;

/**
 * Represents a job that is (about to be) inserting (uploading) data.
 */
public class JobUppingInsertEvent extends StructuredJobInsertEvent {
    
    public JobUppingInsertEvent(int jobnumber, String name, int retry) {
	super(jobnumber, retry, "Upping     ", name);
    }

    public String toJobLogString() {
	return InsertContext.num(retry+1)+" "+ "Upping     "+desc;
    }
}
