package fiw.core.insert.event;

/**
 * Common superclass for all event that indicate the end of a job.
 */
public abstract class JobEndedInsertEvent extends StructuredJobInsertEvent {
    
    public JobEndedInsertEvent(int jobnumber, int retry,
			       String action, String name) {
	super(jobnumber, retry, action, name);
    }
    
    public JobEndedInsertEvent(int jobnumber, int retry,
			       String action, String name,
			       boolean important, boolean logIt) {    
	super(jobnumber, retry, action, name, important, logIt);
    }

    public int getJobStateChange() {
	return JOB_STATE_ENDED;
    }
}
