package fiw.core.insert.event;

import fiw.core.insert.*;
import fiw.core.*;
import java.util.*;


/**
 * Provides an interface between the new InsertListener and the old
 * InsertLogger event systems.
 * @author mihi
 */
public class InsertLoggerListener implements InsertListener {

    public InsertLogger il;
    private HashMap jobNumbers = new HashMap();

    public InsertLoggerListener(InsertLogger il) {
	this.il=il;
    }

    public void insertProgressed(InsertEvent evt) {
	if (evt.isPartialLogString()) {
	    il.addlogNoNewline(evt.toLogString());
	} else if (evt.toLogString() != null) {
	    il.addlog(evt.toLogString());
	}
	int jno= evt.getJobNumber();
	if (jno != 0) {
	    int no;
	    if (evt.isJobStarted()) {
		if (jobNumbers.get(new Integer(jno)) != null) {
		    throw new RuntimeException ("double job number");
		}
		no = il.addThread(jno);
		jobNumbers.put(new Integer(jno), new Integer(no));
	    } else {
		if (jobNumbers.get(new Integer(jno)) == null) {
		    throw new RuntimeException ("No job number for "+jno);
		}
		no = ((Integer)jobNumbers.get(new Integer(jno))).intValue();
		if (no == -2) {
		    throw new RuntimeException ("Using zombie job "+jno);
		}		    
	    }
	    if (evt.toJobLogString() != null) {
		il.setThread(no, evt.toJobLogString());
	    }
	    if (evt.isJobEnded()) {
		il.removeThread(no);
		jobNumbers.put(new Integer(jno), new Integer(-2));
	    }
	}
    }

    public void setStatus(String s) {
	il.setStatus(s);
    }

    public void restart() {
	jobNumbers.clear();
	il.restart();
    }

    public void iamhere(Stoppable ie) {
	il.iamhere(ie);
    }

    public void done() {
	il.done();
    }
}
