package fiw.core.insert.event;
import fiw.core.*;


/**
 * A listener listening for insert events
 * @author mihi
 */
public interface InsertListener {


    void insertProgressed(InsertEvent evt);

    /**
     * Sets some status text for the insert. Calling this method again
     * replaces the status text.
     * @param s the status text
     */
    void setStatus(String s);

    /**
     * Reports that the insert has restarted. All status should be cleared.
     */
    void restart();

    /**
     * Informs the listener how to stop this insert.
     * @param ie the Stoppable to stop this insert.
     */
    void iamhere(Stoppable ie);

    void done();
}
