package fiw.core.insert.event;

/**
 * Common superclass for all insert events
 */
public abstract class AbstractInsertEvent implements InsertEvent {

    public String toLogString() {
	return null;
    }

    public boolean isPartialLogString() {
	return false;
    }

    public int getJobNumber() {
	return 0;
    }
    
    public int getJobStateChange() {
	return JOB_STATE_NO_ACTION;
    }

    public String toJobLogString() {
	return null;
    }

    public String getKey() {
	return null;
    }

    public final boolean isJobStarted() {
	return (getJobStateChange() & JOB_STATE_STARTED) != 0;
    }

    public final boolean isJobEnded() {
	return (getJobStateChange() & JOB_STATE_ENDED) != 0;
    }
}
