package fiw.core.insert;

import fiw.fcp.FECMetrics;
import fiw.core.*;

/**
 * Represents a file inserted into Freenet.
 */
public class InsertableFile extends Insertable {

    private boolean useFEC;
    private FECMetrics fecMetrics = null;
    private SubFile file;
    public InsertableFile(SubFile f, int priority,
			  boolean useFEC) {
	super(priority, f.getSubName(), true);
	this.useFEC=useFEC;
	this.file=f;
    }
    public boolean getUseFEC (){
	return useFEC;
    }

    public void setFECMetrics(FECMetrics fm) {
	fecMetrics = fm;
    }

    public FECMetrics getFECMetrics() {
	return fecMetrics;
    }

    public SubFile getFile() {
	return file;
    }
}
	
