package fiw.core.insert;

/**
 * An object (file, splitfile, container) that can be inserted into
 * Freenet. Every object has a priority that specifies when it will be
 * inserted.
 */
public abstract class Insertable implements Comparable {
    
    protected int priority;
    protected String name;
    private boolean inMapfile;

    public Insertable (int priority, String name, boolean inMapfile) {
	this.priority=priority;
	this.name=name;
	this.inMapfile=inMapfile;
    }
    
    public int getPriority () {
	return priority;
    }
    
    public String getName (){
	return name;
    }
    
    public int compareTo(Object other) {
	return compareTo((Insertable) other);
    }

    public int compareTo(Insertable other) {
	if (this == other) {
	    return 0;
	}
	if (priority != other.priority) {
	    return priority - other.priority;
	}
	return name.toLowerCase().compareTo(other.name.toLowerCase());
    }
    
    public boolean isInMapfile() {
    	return inMapfile;
    }
}    
