package fiw.core.insert;
import fiw.core.*;


/**
 * A logger that logs insert states.
 * @author mihi
 */
public interface InsertLogger extends MyLogger{


    /**
     * Sets some status text for the insert. Calling this method again
     * replaces the status text.
     * @param s the status text
     */
    void setStatus(String s);

    /**
     * Adds a thread to the thread listing.
     * @param globalno the number that should be shown next to the
     * thread status
     * @return a reference number for this thread
     */
    int addThread(int globalno);

    /**
     * Sets the status of a thread to a given string.
     * @param no the reference number for the thread
     * @param s the new thread status
     */
    void setThread(int no, String s);

    /**
     * Sets the status of a thread.
     * @param no the reference number for the thread
     * @param retry the number of current retry
     * @param actionIndex what the thread is doing
     * @param desc description of the thread
     */
    void setThread(int no, int retry, int actionIndex, String desc);

    /**
     * Removes a thread from the thread listing.
     * @param no the reference number for the thread
     */
    void removeThread(int no);

    /**
     * Reports that the insert has restarted. All status should be cleared.
     */
    void restart();

    /**
     * Informs the logger how to stop this insert.
     * @param ie the Stoppable to stop this insert.
     */
    void iamhere(Stoppable ie);
}
