package fiw.core.insert;
import fiw.core.*;
import fiw.core.insert.event.*;

/** Provides a logger that logs into the "new" event system. */
public class InsertListenerLogger implements MyLogger {


    private InsertContext ic;
    
    public InsertListenerLogger(InsertContext ic) {
	this.ic=ic;
    }

    public void addlog(String s) {
	ic.addlog(s);
    }

    public void addlogNoNewline(String s) {
	ic.fireInsertEvent(new PartialInsertEvent(s));
    }

    public void done() {
	ic.fireDone();
    }
}
