package fiw.core.insert;
import fiw.core.*;
import fiw.core.insert.event.*;
import fiw.fcp.*;

import java.io.*;

/** 
 * this class controls (or better starts...) the insertion process. 
 */
    
public class InsertEngine {

    InsertContext ic;    

    private InsertEngine(FCPConnection fc, int htl, InsertListener listener,
			 String xtra) {
	this(fc, htl, listener, xtra, false, false);
    }

    /** private constructor that does the most common things */
    private InsertEngine(FCPConnection fc, int htl, InsertListener listener,
			 String xtra, boolean isProject, boolean testinsert) {
 	if (htl<0) htl=0;
	ic = new InsertContext(fc, testinsert, isProject, htl);
	ic.addInsertListener(listener);
	ToFileInsertLogger l;
 	ic.addInsertListener(new InsertLoggerListener
			     (l = new ToFileInsertLogger(xtra)));
	ic.addlog(l.getLoggerState());
    }

    /** for projects */
    public InsertEngine(FCPConnection fc, int project, int htl,
			boolean clearprogress, boolean useParser,
			InsertListener listener) {
	this(fc, htl, listener,
 	     FIWSystem.setts().getProjectSetting(project,"keydir")+"-"+
 	     (htl==-1?"test-":(htl==-2?"fecmake-":"")),
	     true, htl == -1);
	new ProjectInsertController(ic, project, clearprogress,
				    useParser, htl==-2);
    }

    /** for inserting files or nims */
    public InsertEngine(FCPConnection fc, int htl, boolean adv, String key,
			String ctype, File file, InsertListener listener) {
        this(fc, htl, listener, "file-");
        new FileInsertController(ic,key,adv,ctype,file);
    }

    /** for inserting raw metadata or redirects */
    public InsertEngine(FCPConnection fc, int htl, boolean adv, String key,
			String metadata, InsertListener listener) {
        this(fc, htl, listener, "metadata-");
	new FileInsertController(ic,key, adv, metadata);
    }

}
