package fiw.core.insert;

import fiw.fcp.*;
import fiw.core.*;
import fiw.core.insert.event.*;

import java.util.*;
import java.io.*;


/**
 * This class contains all the hacks needed to make the "old" insert
 * code work in the new Jobs model. One instance of this class exists
 * for every insert and it is handed down to the InsertJob level.
 */

public class InsertContext {
    
    // Strings for actions:
    public static final String[] ACTIONS = new String[] {
	"Start      ",null, null,"Getting    ", // 0 1 2 3
	"   Got     ",null,"***RouteNF ","***DataNF  ", // 4 5 6 7
	"Done          ", null,       null,                     // 8 9 10 
	"Failed        ", "Examining  ", "Identical  ",          // 11 12 13
	"Different  ",   "Aborted       ",null,                 //14 15 16
        "Checking   ", 	"CalcCHK    ","Finished   "               //17 18 19
    };

    // constants for Actions:
    public static final int
	AC_START=0,     AC_GETTING=3,
	TAC_GETTING=3,	AC_GOT=4,       AC_RNF=6,
	AC_DNF=7,	TAC_WIDE_DONE=8,
	              	TAC_FAILED=11, 	AC_EXAM=12, 	AC_IDENT=13,
	AC_DIFF=14, 	TAC_WIDE_ABORTED=15,
	TAC_START=0, AC_CHECK = 17, AC_CALCCHK= 18, TAC_CALCCHK=18,
	AC_FINISHED=19;

    private MyLogger myLogger = new InsertListenerLogger(this);
    public boolean testinsert, testinsertmod,
	modifyMetadata;

    private boolean isProject;
    public boolean verify;
    public int htl, fetchHTL;

    public InsertContext(FCPConnection fcpconn,
			 boolean testinsert, boolean isProject,
			 int htl) {
	this(fcpconn, testinsert, isProject, htl,-1);
    }

    // contructor
    public InsertContext(FCPConnection fcpconn,
			 boolean testinsert, boolean isProject,
			 int htl, int fetchHTL) {
	fcpConn=fcpconn;
	this.testinsert=testinsert;
	this.testinsertmod=testinsert && MODIFYURL;
	this.isProject=isProject;
	this.verify=testinsert?VERIFYTEST:VERIFY;
	this.htl=htl;
	if (fetchHTL == -1) {
	    this.fetchHTL=(htl==0?htl:htl+HTLINC);
	} else {
	    this.fetchHTL=fetchHTL;
	}
	if (testinsert && MODIFYTEST) {
	    modifyMetadata=true;
	}
    }

    public boolean isTestInsert() {
	return testinsert;
    }

     public MyLogger getMyLogger() {
	 return myLogger;
     }

    // global tuning options
    
    // was const before, so uppercase
    public final int RETRIEVERETRY, HTLINC, INSERTRETRY, FECMINSIZE, THREADS,
	MAXNIMSIZE, DEFAULT_PRIORITY;
    public final boolean VERIFY, VERIFYTEST, CHECKPROGRESS, MODIFYTEST,
	TESTNOFEC, MODIFYURL, NODBRMISMATCH;
    public final String[] NOFECEXTS;
    public final String VERIFYFLAGS;

    { //non-static initializer
        RETRIEVERETRY=loadInt("tuning.fetchtry");
        INSERTRETRY=loadInt("tuning.inserttry");
        HTLINC=loadInt("tuning.htlinc");
        THREADS=loadInt("tuning.threadcount");
	FECMINSIZE=loadInt("tuning.fecminsize");
	MAXNIMSIZE=loadInt("tuning.maxnimsize");
        CHECKPROGRESS=loadBool("tuning.checkprogressfile");
        VERIFY=loadBool("tuning.doverify");
        VERIFYTEST=loadBool("tuning.doverifytest");
	MODIFYTEST=loadBool("tuning.modifytest");
	MODIFYURL=loadBool("tuning.modifyurl");
	TESTNOFEC=loadBool("tuning.testnofec");
	NODBRMISMATCH=loadBool("tuning.nodbrmismatch");
	VERIFYFLAGS=FIWSystem.setts().getProperty("tuning.verifyflags");
	String nfe=FIWSystem.setts().getProperty("tuning.nofecexts");
	StringTokenizer nfet=new StringTokenizer(nfe);
	NOFECEXTS=new String[nfet.countTokens()];
	for(int i=0;i<NOFECEXTS.length;i++) {
	    String nto=nfet.nextToken();
	    if (!nto.startsWith(".")) nto="."+nto;
	    NOFECEXTS[i]=nto;
	}
	DEFAULT_PRIORITY=loadInt("tuning.priority");

    }
    
    /** checks if verifyflags allow verifying in a given
     * situation. The order of VERIFYFLAGS is (notest-project-middle,
     * notest-project-end, notest-file-middle, notest-file-end) and
     * the same for test. */
    public boolean doVerify(boolean atend) {
	if (! verify) return false;
	return ('1' == VERIFYFLAGS.charAt((testinsert?4:0)+
					  (!isProject?2:0)+
					  (atend?1:0)));
    }

    private static int loadInt(String prop) {
	return Integer.parseInt(FIWSystem.setts().getProperty(prop));
    }

    private static boolean loadBool(String prop) {
	return "true".equals(FIWSystem.setts().getProperty(prop));
    }

    // a way to abort
    private boolean shouldStop=false;

    public synchronized boolean shouldStop() {
	return shouldStop;
    }

    public synchronized void doStop() {
	shouldStop=true;
    }

    private boolean retryFutile = false;
    
    public synchronized boolean isRetryFutile() {
	return retryFutile;
    }

    public synchronized void setRetryFutile() {
	retryFutile = true;
    }

    // logging

    public List listeners = new ArrayList();
    
    public void addInsertListener(InsertListener il) {
	listeners.add(il);
    }

    public void removeInsertListener(InsertListener il) {
	listeners.remove(il);
    }

    public void fireInsertEvent(InsertEvent evt) {
	for (Iterator it=listeners.iterator(); it.hasNext();) {
	    ((InsertListener)it.next()).insertProgressed(evt);
	}
    }

    public void fireRestart() {
	for (Iterator it=listeners.iterator(); it.hasNext();) {
	    ((InsertListener)it.next()).restart();
	}
    }

    public void fireDone() {
	for (Iterator it=listeners.iterator(); it.hasNext();) {
	    ((InsertListener)it.next()).done();
	}
    }
    
    public void fireSetStatus(String s) {
	for (Iterator it=listeners.iterator(); it.hasNext();) {
	    ((InsertListener)it.next()).setStatus(s);
	}
    }
	
    public void fireIAmHere(Stoppable st) {
	for (Iterator it=listeners.iterator(); it.hasNext();) {
	    ((InsertListener)it.next()).iamhere(st);
	}
    }

	
    /** adds a single line to the log */
    public synchronized void addlog(String s) {
	fireInsertEvent(new InfoInsertEvent(s));
    }

    /** adds a formatted line to the log */
    public synchronized void addlog(int prefix, int retry,
				    int actionIndex, String desc) {
	fireInsertEvent(new StructuredJobInsertEvent
			(prefix, retry, ACTIONS[actionIndex], desc));
    }

    /** formats a number with format 00 */
    public static String num(int number) {
	return Settings.twoDigits(number);
    }

    // RNF with all unreachable handling
    private int allUnreachable=0;
    private static final int UNREACHABLE_LIMIT = 10;
    
    public synchronized void notAllUnreachable() {
	allUnreachable=0;
    }

    public synchronized boolean allUnreachable() {
	allUnreachable++;
	return allUnreachable > UNREACHABLE_LIMIT;
    }

    public synchronized boolean isAllUnreachable() {
	return allUnreachable > UNREACHABLE_LIMIT;
    }

    public synchronized void newChanceForUnreachable() {
	if (allUnreachable >UNREACHABLE_LIMIT) {
	    allUnreachable= UNREACHABLE_LIMIT-3;
	}
    }


    // --- progress things ---
    File progressFile=null;
    Properties progress=new Properties();

    public synchronized boolean loadProgress (File progressFile, boolean clearProgress) {
	this.progressFile=progressFile;
 	if (clearProgress) {
 	    addlog("*** Clearing progress file...");
 	    saveProgress();
 	} else {
 	    try {
 		addlog("*** Looking for progress file...");
 		InputStream in=new FileInputStream(progressFile);
 		progress.load(in);
 		in.close();
 		addlog("*** Loaded progress file.");
 	    } catch (FileNotFoundException e) {
 		addlog("*** No progress file found.");
 	    } catch (IOException e) {
 		e.printStackTrace();
 		e.printStackTrace(FIWSystem.log());
 		addlog("[Error] while loading progress file");
 		return false;
 	    }
 	}
	return true;
    }
    
    public synchronized void dataInserted(String progressName, String key) {
	progress.setProperty(progressName,key);
	progress.setProperty("Time."+progressName,
			     ""+System.currentTimeMillis());
	saveProgress();
    }

    public synchronized void dataNotInserted(String progressName) {
	progress.remove(progressName);
	saveProgress();
    }

    /** saves the progress file */
    private synchronized void saveProgress() {
	if (progressFile !=null) {
	    if (!FileUtil.saveProperties(progress,progressFile,
					 "Progress file")) {
		addlog("[Warning] Could not save progress file.");
	    }
	}
    }

    /**
     * checks if a job with name <tt>progressName</tt> has already
     * been done.
     * @return the CHK of the job, or null if it has not been
     * done.
     */
    public String alreadyDone (String progressName) {
	String res=null;
	if (CHECKPROGRESS) {
	    res=progress.getProperty(progressName);
	    if (res != null) {
		//FIXME: timecheck
	    }
	}
	return res;
    }


    // FCPConnection

    private FCPConnection fcpConn;

    public FCPConnection getFCPConnection() {
	return fcpConn;
    }
}
