package fiw.core.insert;

import java.util.*;
import fiw.core.*;

import java.io.*;

/**
 * Represents a container inserted into Freenet that contains multiple files.
 */
public class FreenetContainer extends Insertable {

    private boolean insertAsFile;
    private File file;
    
    private ArrayList files = new ArrayList();
    public FreenetContainer(int priority, String filename,
			    boolean insertAsFile, File file) {
	super(priority, filename, insertAsFile);
	this.insertAsFile=insertAsFile;
	this.file=file;
    }

    public boolean isInsertedAsFile (){
	return insertAsFile;
    }

    public void addFile(SubFile file) {
	files.add(file);
    }

    public File getContainerFile() {
	return file;
    }

    public List getFiles() {
	return Collections.unmodifiableList(files);
    }
}
	
