package fiw.core.insert;

import fiw.core.jobs.*;
import fiw.core.*;
import fiw.Main;

import java.io.*;
import java.util.*;

/** Controller for inserting files, nims,
 * redirects and raw metadata - in short, everything else than
 * projects */
public class FileInsertController extends InsertController {

    String key;
    String ctype;
    String mdata;
    File f;
    boolean advance;
    Thread myThread;
        
    public FileInsertController(InsertContext ic,
				String key, boolean adv, String ctype,
				File f) {
	super(ic);
	this.key=key;this.ctype=ctype;this.f=f;
	this.advance=adv;
	myThread = new Thread(this);
	myThread.start();
    }

    public FileInsertController(InsertContext ic,
				String key, boolean adv, String metadata) {
	super(ic);
	this.key=key;this.mdata=metadata;this.f=null;
	this.advance=adv;
	myThread = new Thread(this);
	myThread.start();
    }
            
        
    public boolean insert() {
	if (f==null) {
	    ic.addlog("======== Inserting metadata (FIW "+
		      Main.VERSION+") =========\n"+
		      "HTL: "+ic.htl+"\n"+
		      "Key: "+mungeSSK(key)+"\n"+
		      "Start of insert: "+FileUtil.dateString2()+"\n"+
		      "FCP host/port: "+fc.getHost()+":"+ fc.getPort()+"\n"+
		      (advance?"[AutoAdvance]\n":"")+
		      "==============================================*=\n\n");
	} else {
	    ic.addlog("========== Inserting file (FIW "+
		      Main.VERSION+") ===========\n"+
		      "Filename: "+f.getName()+"\n"+
		      "Content-Type: "+ctype+"\n"+
		      "HTL: "+ic.htl+"\n"+
		      "Key: "+mungeSSK(key)+"\n"+
		      "Start of insert: "+FileUtil.dateString2()+"\n"+
		      "FCP host/port: "+fc.getHost()+":"+ fc.getPort()+"\n"+
		      (advance?"[AutoAdvance]\n":"")+
		      "==============================================*=\n\n");
	}
	List verifyList = new ArrayList();
	Job[] jobs;
	int resJob = -1;
	if (ic.shouldStop()) {
	    jobs = new Job[0];
	} else if (f!=null
		   && (f.length() < ic.MAXNIMSIZE || key.equals("CHK@"))
		   && !key.equals("none")) { // one part file
	    jobs=new Job[1];
	    jobs[0]= new FileInsertJob(f,"metadata+data", ctype, "",
				       true,
				       key, "Version\nRevision=1\nEndPart\n"+
				       "Document\nInfo.Format="+ctype+
				       "\nEnd\n",ic, new Job[0]);
	    if (advance) ((InsertJob)jobs[0]).setFallback(advanceFallback);
	    verifyList.add(jobs[0]);
	    resJob=0;
	} else if (f!=null && !key.equals("none")) {
	    jobs=new Job[3];
	    jobs[0]= new FileInsertJob(f,"file", ctype, "",
				       true, false, ic, new Job[0]);
	    ((InsertJob)jobs[0]).setCalcOnly();
	    jobs[1] = new MetadataInsertJob(key, null, "metadata", ic,
					    new Job[]{jobs[0]});
	    jobs[2] = new FileInsertJob(f,"file", ctype, "",
				       true, false, ic, new Job[0]);
	    if (advance) ((InsertJob)jobs[1]).setFallback(advanceFallback);
	    verifyList.add(jobs[1]);
	    verifyList.add(jobs[2]);
	    resJob = 1;
	} else if (f!=null && key.equals("none")) {
	    jobs=new Job[1];
	    jobs[0]= new FileInsertJob(f,"file", ctype, "", true,
				       false, ic, new Job[0]);
	    verifyList.add(jobs[0]);
	    resJob=0;
	} else { // if (f == null) 
	    jobs=new Job[1];
	    jobs[0]= new MetadataInsertJob(key, mdata, "metadata",ic,
					   new Job[0]);
	    resJob=0;
	    if (advance) ((InsertJob)jobs[0]).setFallback(advanceFallback);
	    verifyList.add(jobs[0]);
	}
	if (ic.doVerify(true)) {
	    int jc = jobs.length, jc2 = verifyList.size();
	    Job[] newjobs = new Job[jc+jc2+1];
	    System.arraycopy(jobs,0,newjobs,0,jc);
	    newjobs[jc] = new DummyJob("=============================\n"+
				       "Fetching inserted data again:",
				       ic, jobs);
	    for (int i=0;i<jc2;i++) {
		newjobs[jc+i+1] = ((InsertJob)verifyList.get(i))
		    .buildChecker(true, null, newjobs[jc]);
	    }
	    jobs = newjobs;
	}
	boolean fail = false;
	if (!ic.shouldStop()) {
	    fail = !runJobList(jobs);
	}
	if (ic.shouldStop()) {
	    ic.addlog ("\n+++ Aborted +++");
	} else if (fail) {
	    ic.addlog("Fatal error. Quitting.");
	    ic.fireSetStatus(I18n.get("Error"));
	    ic.addlog("\n+++ FAILED +++");
	    return false;
	} else {
	    ic.addlog("\n+++ FINISHED +++\n");
	    if (resJob != -1) 
		ic.addlog("Your URI: "+
			  ((InsertJob)jobs[resJob]).getResultKey());
	}
	return true;
    }

    /**
     * munges a SSK (for private keys in logfiles). New format is
     * SSK@XWyj[--cut--]pCIh/filename.
     */
    public static String mungeSSK(String key) {
        if (key.startsWith("SSK@")) {
            int endPos=key.indexOf("/");   //SSK@12345678/
            if (endPos > 12) {
                key=key.substring(0,8 ) +"[--cut--]"+
                    key.substring(endPos-4);
            }
        }
        return key;
    }

    
    private static KeyFallback advanceFallback = new KeyFallback() {
	    public String nextKey(String key) {
		if (key== null || key.equals("CHK@")) {
		    return null;
		}
		int p = key.lastIndexOf("-");
		if (p == -1) return null;
		try {
		    int after = Integer.parseInt(key.substring(p+1));
		    return key.substring(0,p+1) + (after+1);
		} catch (NumberFormatException e) {
		    return null;
		}
	    }   
	};   
}
