package fiw.core.insert;

/**
 * Specifies a group of file (by their filename) that should be
 * treated by the new insert engine in a similar manner (e.g. put into
 * a container...).
 */
public class FileClass {
    private int matchtype, priority;
    private FreenetContainer container;
    private String match;

    public static final int
	EXACT_MATCH=0, END_MATCH=1, REGEX_MATCH=2;
    
    public FileClass(int matchtype, String match, int priority,
		     FreenetContainer container) {
	this.matchtype=matchtype;
	this.match=match;
	this.priority=priority;
	this.container=container;
    }

    public int getPriority () {
	return priority;
    }
    public boolean isContainer() {
	return container != null;
    }

    public FreenetContainer getContainer() {
	return container;
    }

    public boolean matchesFile(String filename) {
	switch(matchtype) {
	case EXACT_MATCH:
	    return filename.equals(match);
	case END_MATCH:
	    return filename.endsWith(match);
	case REGEX_MATCH:
	    return filename.matches(match);
	default:
	    throw new UnsupportedOperationException("Unknown match type");
	}
    }
}
    
