package fiw.core;

import java.io.*;

/**
 * A logger that logs everything to a file.
 * @author mihi
 */
public class ToFileLogger implements MyLogger {
    
    private PrintWriter logfile;

    private String loggerState = null;

    /**
     * Creates a new ToFileLogger.
     * @param xtrasuffix a text placed between "<code>report-</code>"
     * and "<code><i>date</i>.log</code>". When not empty, it should
     * end with a dash.
     */
    public ToFileLogger(String xtrasuffix) {
	try {
            String filename="report-"+noPunctuation(xtrasuffix)+
		FileUtil.dateString()+".log";
            logfile=new PrintWriter(new FileWriter(filename),true);
            loggerState="Report is saved as \""+filename+"\".\n";
        } catch(IOException e) {
            logfile=null;
            loggerState="No report is saved - IO error.\n";
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
        }
    }

    private String noPunctuation(String s) {
	StringBuffer sb = new StringBuffer(s.length());
	for (int i=0; i<s.length();i++) {
	    char c = s.charAt(i);
	    if (c == '-' || Character.isLetterOrDigit(c)) {
		sb.append(c);
	    }
	}
	return sb.toString();
    }

    public String getLoggerState() {
	return loggerState;
    }
    
    /**
     * adds lines to the log.
     * @param s the line(s).
     */
    public synchronized void addlog(String s) {
        if (logfile !=null) {
            // unify newlines
            int pos;
            while((pos=s.indexOf("\n"))!=-1) {
                logfile.println(s.substring(0,pos));
                s=s.substring(pos+1);
            }
	    logfile.println(s);    
        }
    }

    /**
     * adds a part of a line to the log.
     * @param s the line part.
     */
    public synchronized void addlogNoNewline(String s) {
        if (logfile !=null) {
	    logfile.print(s);
        }
    }

    /**
     * notifies the logger that it not needed any more.
     */
    public synchronized void done() {
	if (logfile != null) {
	    logfile.close();
	}
    }
}
