package fiw.core;

import java.io.*;
import java.util.*;

/** a file containing a pathname relative to a specified directory,
 * useful for handling recursive file search. Note that always "/"
 * will be used as path separator. Special version for fiw concerning
 * "parsed" dirs */

public class SubFile extends File {
    private String subName;

    public SubFile(File parent, String name, String prefix) {
	super(parent,name);
	subName=prefix+name;
    }
    public void setSubName(String sn) {
	subName=sn;
    }
    public String getSubName() {
	return subName;
    }

    public static SubFile[] listSubFiles(File root, List ignoreFiles) {
	ArrayList cache=new ArrayList();
	listSubFiles("",root,getParsedDir(root),cache, ignoreFiles);
	return (SubFile[]) cache.toArray(new SubFile[0]);
    }

    private static File getParsedDir(File r) {
	File f=FileUtil.fiwDir(r);
	f=new File(f,"parsed");
	if (!f.exists()) f.mkdir();
	return f;
    }
    
    private static void listSubFiles(String prefix, File root,
				     File rootParsed, 
				     ArrayList cache, List ignoreFiles) {
	File[] sons=root.listFiles();
	for (int i=0;i<sons.length;i++) {
	    File parsedFile = new File(rootParsed,sons[i].getName());
	    if (sons[i].getName().startsWith(".")) 
		continue; // ignore .hidden files
	    if (ignoreFiles != null && ignoreFiles.contains(sons[i].getName()))
		continue; // other ignored file names
	    if (sons[i].isDirectory() &&
		       !sons[i].getName().startsWith("__")) {
		listSubFiles(prefix+sons[i].getName()+"/",sons[i],
			     parsedFile, cache, ignoreFiles);
	    } else if (!sons[i].isDirectory()){
		if (parsedFile.exists()) {
		    cache.add(new SubFile(rootParsed, sons[i].getName(),
					  prefix));
		} else {
		    cache.add(new SubFile(root, sons[i].getName(),prefix));
		}
	    }
	}
    }
}
	
