package fiw.core;
import fiw.core.insert.*;
import fiw.core.insert.event.*;
import fiw.fcp.FCPConnection;

/**
 * Checks for new NIMs. Most of the job is done by
 * {@link NimCheckerController}.
 * @author mihi
 */
public class NimChecker {

    /**
     * Starts the NIM checking.
     * @param il a logger
     * @param htl the HTL for checking
     * @param advance the number of NIMs to fetch from each project
     */
    public NimChecker(FCPConnection fc, InsertListener il, int htl,
		      int advance) {
	InsertContext ic = new InsertContext(fc,false, false, 0, htl);
	ic.addInsertListener(il);
	ic.addInsertListener(new InsertLoggerListener
			     (new ToFileInsertLogger("nimcheck-")));
	new NimCheckerController(ic, advance);
    }
}
