package fiw.core;

/**
 * Classes implementing this interface are general Loggers which can
 * get a line of text to log and get informed when they should stop
 * logging.
 * @author mihi
 */
public interface MyLogger {
    /**
     * Adds a line (or more lines) to the log. Lines are separated by
     * newline characters.
     * @param s the line(s).
     */
    public void addlog(String s);

    /**
     * Adds a part of the line to the log. Subsequent calls of this
     * method or of {@link #addlog} are added to the same line.
     * @param s the line part.
     */
    public void addlogNoNewline(String s);


    /**
     * "Closes" the logger - after this method is called, no other
     * methods (including this one) implemented from this interface
     * may be called.
     */
    public void done();
}
