package fiw.core;

import java.util.*;
import java.text.*;

/**
 * This class is responsible for internationalization issues.
 */
public class I18n {

    public I18n() {
	this(Locale.getDefault());
    }

    public I18n(String locale) {
	this(getLocaleFromString(locale));
    }
    
    public I18n(Locale l) {
	locale = l;
	rb = ResourceBundle.getBundle("res/language", locale);
    }
    
    private Locale locale=null;
    private ResourceBundle rb = null;

    private static Locale getLocaleFromString(String locale) {
	int pos = locale.indexOf("_");
	Locale l;
	if (pos == -1) {
	    l = new Locale(locale);
	} else {
	    String lang = locale.substring(0, pos);
	    String rest = locale.substring(pos+1);
	    pos = locale.indexOf("_");
	    if (pos == 0) {
		l = new Locale(lang, rest);
	    } else {
		String country = locale.substring(0, pos);
		rest = locale.substring(pos+1);
		l = new Locale(lang, country, rest);
	    }
	}
	return l;  
    }
    
    public static String get(String name) {
	return FIWSystem.getInstance().getI18n().getString(name);
    }

    public static String format(String format, Object param) {
	return format(format, new Object[] {param});
    }
    
    public static String format(String format, Object[] params) {
	I18n i = FIWSystem.getInstance().getI18n();
	String form=i.getString(format);
	return new MessageFormat(form, i.getLocale())
	    .format(params);
    }
    
    public String getString(String name) {
	return rb.getString(name);
    }

    public Locale getLocale() {
	return locale;
    }
}
