package fiw.core;
import fiw.fcp.*;
import java.io.*;

/**
 * Central singleton class holding subsystem instances and factory
 * methods for them.
 * @author mihi
 */
public class FIWSystem {

    public static FIWSystem instance;
    public static final boolean doFullLog=false;

    private FIWSystem() {}
    
    public static synchronized FIWSystem getInstance() {
	if (instance == null) {
	    instance=new FIWSystem();
	}
	return instance;
    }

    private FCPConnection fcpConn = null;
    private Settings settings = null;
    private I18n i18n = null;
    private PrintStream log = null, fullLog = null;

    
    protected synchronized void setFCPConnection(FCPConnection fcpconn) {
	fcpConn=fcpconn;
    }

    public synchronized FCPConnection createFCPConnection(String host,
							  int port) {
	fcpConn=FCPConn.fcpFactory(host,port);
	return fcpConn;
    }

    /** creates an FCP connection to the default destination */
    public synchronized FCPConnection createFCPConnection() {
	return createFCPConnection
	    (getSettings().getProperty("fcp.host"),
	     Integer.parseInt(getSettings().getProperty("fcp.port")));
    }

    public synchronized FCPConnection getFCPConnection() {
	if (fcpConn==null) {
	    System.out.println("Warning: Creating FCP connection!");
	    return createFCPConnection();
	}
	return fcpConn;
    }

    public synchronized Settings getSettings() {
	if (settings == null) {
	    settings=Settings.getInstance();
	}
	return settings;
    }

    public synchronized I18n getI18n() {
	if (i18n == null) {
	    String locale = getSettings().getProperty("locale");
	    if (locale == null || locale.equals("")) {
		i18n = new I18n();
	    } else {
		i18n = new I18n(locale);
	    }
	}
	return i18n;
    }

    public synchronized void setLanguage(String locale) {
	getSettings().setProperty("locale",locale);
	i18n = null;
    }

    public synchronized PrintStream getLog() {
	initLogs();
	return log;
    }

    public synchronized PrintStream getFullLog() {
	initLogs();
	return fullLog;
    }
    
    private void initLogs() {
	if (log == null) {
	    try {
		log=new PrintStream(new FileOutputStream
				    ("logfile.log",true),true);
		log.println("SESSION: "+new java.util.Date());
		if (doFullLog) {
		    fullLog=new PrintStream
			(new FileOutputStream("logfile2.log", true),true);
		    fullLog.println("FULL LOG SESSION: "+new java.util.Date());
		}
	    } catch (IOException e) {
		e.printStackTrace();
	    }
	}
    }

    // convenience methods
    
    public static PrintStream log() {
	return getInstance().getLog();
    }

    public static Settings setts() {
	return getInstance().getSettings();
    }
}


    
