package fiw.core;

import java.util.*;
import java.io.*;

/**
 * Class that determines the correct content type for a given filename.
 */
public class ContentTypeManager {

    private Properties cntTypes = null;
    private String htmlCharset;
    /**
     * Creates a new ContentTypeManager.
     * @param htmlCharset The charset that should be used for HTML
     * files (in Freenet, the charset is part of the content type) or
     * an empty string to use the default
     * @throws FileNotFoundException if the content type file could not
     * be found;
     */
    public ContentTypeManager (String htmlCharset)
	throws FileNotFoundException {
	this.htmlCharset=htmlCharset;
	try {
	    InputStream in=Settings.class.getResourceAsStream
		("/res/mimetype.txt");
	    if (in==null) {
		System.err.println("There is *no* mimetype.txt in your jar.");
		throw new FileNotFoundException();
	    }
	    Properties cntTypes2 = new Properties();
	    cntTypes2.load(in);
	    in.close();	    
	    cntTypes=new Properties(cntTypes2);
	    cntTypes.load(in= new FileInputStream("mimetype.conf"));
	    in.close();
	    if (cntTypes.getProperty("png") == null) {
		System.err.println("Your content type file is fscked up.");
		if (cntTypes2.getProperty("png") != null) {
		    System.err.println("Possible JVM bug?");
		}   
		throw new FileNotFoundException();
	    }
		    
	} catch (FileNotFoundException e) {
	    throw e;
	} catch (IOException e) {
	    System.err.println("FATAL ERROR WHILE LOADING MIME TYPES:");
	    e.printStackTrace();
	    System.exit(-1);
	}
    }
        
    /** adds the charset into the content-type, if applicable */
    public String parseEncoding(String ctype) {
	if (ctype.equals("text/html") && htmlCharset.length() != 0) {
	    return ctype+";charset="+htmlCharset;
	} else {
	    return ctype;
	}
    }
    
    public String getCType (String filename) {
	int posi;
	if ((posi=filename.indexOf('.'))==-1) {
	    return "application/octet-stream";
	} else {
	    String ct = cntTypes.getProperty
		(filename.substring(posi+1).toLowerCase());
	    if (ct==null) ct = "application/octet-stream";
	    return parseEncoding(ct);
	}
    }

    public List getIgnoredFileNames () {
	List result = new ArrayList();
	Iterator it = new EnumerationIterator(cntTypes.propertyNames());
	while (it.hasNext()) {
	    String key = (String) it.next();
	    if (key.startsWith("-ignore-") &&
		cntTypes.get("-noignore-"+key.substring(8)) == null)  {
		result.add(key.substring(8));
	    }
	}
	return result;
    }
}
