package fiw.cli;

import fiw.core.*;
import fiw.gui.awt.*;
import fiw.fcp.*;
import fiw.core.insert.*;
import fiw.core.insert.event.*;
import fiw.Main;

/**
 * Contains code for inserting projects or files via (non-interactive)
 * command line.
 * @author mihi
 */
public class CliInsert implements InsertLogger {

    /**
     * Lists all projects to stdout.
     */
    public static void listProjects() {
	String[] pr=FIWSystem.setts().getProjectNames();
	for(int i=0;i<pr.length;i++) {
	    System.out.println("["+(i+1)+"] "+pr[i]);
	}
    }

    /**
     * Inserts a file.
     */
    public static void cliInsertFile(String[] args) {
	if (args.length==5) {
	    FCPConnection fc = Main.doNodeHello();
	    new InsertEngine(fc, Integer.parseInt(args[1]),
			     false,
			     args[2],
			     args[3],
			     new java.io.File(args[4]),
			     new InsertLoggerListener
			     (new CliInsert()));
	} else {
	    System.out.println("Usage: fiw cliinsfile htl key mimetype"+
			       " filename.");
	}
    }

    /**
     * Inserts a project
     */
    public static void cliInsertProject(String[] args) {
	int project,htl;
	try {
	    project = Integer.parseInt(args[0]) - 1;
	    if (project <0 || project >= FIWSystem.setts().getProjCount()) {
		System.err.println("Incorrect project number");
		return;
	    }
	    htl=Integer.parseInt(args[2]);
	    if ("true".equals(FIWSystem.setts().getProjectSetting(project,
							      "dbr"))) {
		int first=1,last=1;
		if (args.length==4) {
		    first=last=Integer.parseInt(args[3]);
		} else if (args.length==5) {
		    first=Integer.parseInt(args[3]);
		    last=Integer.parseInt(args[4]);
		}
		long increment, offset;
		long firstx, lastx;
		increment=Integer.parseInt
		    (getval(project,"dbr.increment","86400"));
		if (increment==0) increment=86400;
		offset=Integer.parseInt
		    (getval(project,"dbr.offset","0"));
		long timetemp=System.currentTimeMillis()/1000-offset;
		timetemp=((timetemp/increment))*increment+offset;
		firstx=timetemp+ first*increment;
		lastx=timetemp+ last*increment;
		FIWSystem.setts().saveProject(project,"dbr.first",""+firstx);
		FIWSystem.setts().saveProject(project,"dbr.last",""+lastx);    
	    } else {
		if (args.length==4) {
		    int edvalue=Integer.parseInt(args[3]);
		    if (edvalue < 0 || !args[3].equals(""+edvalue)) {
			System.err.println("Incorrect Edition number");
			return;
		    }
		    FIWSystem.setts().saveProject(project, "editionx",args[3]);
		} else if (args.length==5) {
		    System.err.println("NO DBR site!");
		    return;
		}
	    }
	    FCPConnection fc = Main.doNodeHello();
	    InsertLogger logr;
	    if (args[1].toLowerCase().equals("cliins")) {
		logr=new CliInsert();
	    } else {
		logr = new InsertDialog(true,true);
	    }
	    new InsertEngine(fc, project,htl,false, true,
			     new InsertLoggerListener(logr));
	} catch (NumberFormatException e) {
	    System.err.println("Not a number: "+e.getMessage());
	}
    }

    /**
     * Checks NIMs.
     */
    public static void cliCheckNims(String[] args) {
	if (args.length==3) {
	    FCPConnection fc = Main.doNodeHello();
	    InsertLogger il;
	    if (args[0].toLowerCase().equals("guichecknims")) {
		il = new InsertDialog(false, true);
	    } else {
		il = new CliInsert();
	    }
	    new NimChecker(fc, new InsertLoggerListener(il),
			   Integer.parseInt(args[1]),
			   Integer.parseInt(args[2]));
	} else {
	    System.out.println("Usage: fiw "+args[0]+" HTL advance");
	}
    }

    /**
     * Returns a value of a project setting.
     * @param project the project number.
     * @param name the name of the setting
     * @param def a default value.
     */
    private static String getval(int project, String name, String def) {
	String ret=FIWSystem.setts().getProjectSetting(project,name);
	if (ret==null) ret=def;
	return ret;
    }

    
    /**
     * Logs to stdout
     */
    public void addlogNoNewline(String s) {
	System.out.print(s);
    }

    /**
     * Logs to stdout
     */
    public void addlog(String s) {
	System.out.println(s);
    }

    /**
     * Terminates the virtual machine
     */
    public void done() {
	System.exit(0);
    }

    public void setStatus(String s) {}
    public int addThread(int globalno) {return -1;}
    public void setThread(int no, String s) {}
    public void setThread(int no, int retry, int actionIndex, String desc) {}
    public void removeThread(int no) {}
    public void restart() {}
    public void iamhere(Stoppable ie) {}

}
