package fiw.addon;
import fiw.fcp.*;
import fiw.core.*;

import java.util.regex.*;

/**
 * Creates an SSK where the public key matches a regex. This class
 * requires Java 1.4 or higher.
 * @author mihi
 */
public class SSKNicer {

    /**
     * this is not included into Main.java, as it requires Java
     * 1.4. So it is loaded via reflection.
     */
    public static void makeNiceSSK (String regex) {
	Pattern p = Pattern.compile(regex);
	System.out.println("public -- private:");
	while(true) {
	    FCPConnection fc = FIWSystem.getInstance().createFCPConnection();
	    SSKPair keys=fc.getNewSSK();
	    System.out.println(keys.getPrivateKey()+" -- "+
			       keys.getPublicKey());
	    if (p.matcher(keys.getPrivateKey()).find()) break;
	}
	System.out.println("Found!");
    }
}

