package fiw;
import fiw.core.*;
import fiw.gui.awt.*;
import fiw.fcp.*;
import fiw.addon.*;
import fiw.core.insert.*;
import fiw.core.insert.event.*;
import fiw.cli.*;

/**
 * This class contains the main entry point of FIW. It does most of
 * the (more simpler) command line handling and is responsible for
 * maintaining current version number.
 * @see fiw.cli.Cli
 * @author mihi
 */

public class Main {

    /**
     * Current version number.
     */
    public static final String VERSION = "0.08";

    /**
     * Main method.
     * @param args Command line arguments.
     */
    public static void main(String[] args) {
	System.out.println("Freesite Insertion Wizard "+VERSION+"\n");
	if (args.length==0) {
	    	new Wizard();
	} else if (args[0].toLowerCase().equals("cli")) {
	    new Cli().start();
	} else if (args[0].toLowerCase().equals("list")) {
	    CliInsert.listProjects();
	} else if (args[0].toLowerCase().equals("language")) {
	    if (args.length==2) {
		FIWSystem.getInstance().setLanguage(args[1]);
		System.out.println("Language changed.");
	    } else {
		System.out.println("Available languages:");
		String[] langs = GUIHelper.getInstance()
		    .getAvailableLanguages();
		for (int i=0;i<langs.length;i++) {
		    System.out.println(langs[i]);
		}
	    }
	} else if (args[0].toLowerCase().equals("delete")) {
	    FCPConnection fc = doNodeHello();
	    for (int i=1;i<args.length;i++) {
		FCPGetResult res=fc.fetchFingerprint(args[i],0,true);
		System.out.println
		    ("Before deleting: "+
		     (res instanceof FingerprintResult?"DataFound":
		      (res instanceof RouteNotFoundResult?"RouteNotFound":
		       (res instanceof DataNotFoundResult?"DataNotFound":
			(res instanceof SocketTimeoutResult?"SocketTimeout":
			 "Unexpected Error")))));
		System.out.println("After deleting: "+
				   fc.deleteKey(args[i]));
	    }
	} else if (args[0].toLowerCase().equals("mdbrowser")) {
	    FCPConnection fc = doNodeHello();
	    new MetaDataBrowser(fc, true);
	} else if (args[0].toLowerCase().equals("loadstatus")) {
	    FCPConnection fc = doNodeHello();
	    new LoadStatus(fc, true);
	} else if (args[0].toLowerCase().equals("makereport")) {
	    FIWSystem.setts().makeReport();
	    System.out.println("report saved as fiw-conf-report.log");
	} else if (args[0].toLowerCase().equals("guiinsfile")) {
	    if (args.length==5) {
		FCPConnection fc = doNodeHello();
		new InsertEngine(fc, Integer.parseInt(args[1]),
				 false,
				 args[2],
				 args[3],
				 new java.io.File(args[4]),
				 new InsertLoggerListener
				 (new InsertDialog(false)));
	    } else {
		System.out.println("Usage: fiw guiinsfile htl key mimetype"+
				   " filename.");
	    }
	} else if (args[0].toLowerCase().equals("cliinsfile")) {
	    CliInsert.cliInsertFile(args);
	} else if (args[0].toLowerCase().equals("dbrcalc")) {
	    if (args.length==4) {
		DBRcalc.calc(args[1],Integer.parseInt(args[2],16)*86400L,
		     Integer.parseInt(args[3],16)*86400L);
	    } else if (args.length==2) {
		DBRcalc.calc(args[1],86400,0);
	    } else {
		System.out.println("Usage: fiw DBRcalc yyyymmdd [incr offs]\n"+
				   "incr and offs are hex and in days.");
	    }
	} else if (args[0].toLowerCase().equals("genkey")) {
	    if (args.length==2) {
		doNodeHello();
		makeNiceSSK(args[1]);		
	    } else {
		System.out.println("Usage: fiw GenKey regex\n"+
				   "       needs Java 1.4 or higher.");
	    }
	} else if (args[0].toLowerCase().equals("clichecknims")
		   || args[0].toLowerCase().equals("guichecknims")) {
	    CliInsert.cliCheckNims(args);
	} else if (args.length==2
		   && args[1].toLowerCase().equals("updatenim")) {
	    try {
		int project = Integer.parseInt(args[0]) - 1;
		if (project <0 || project >= FIWSystem.setts().getProjCount()) {
		    System.err.println("Incorrect project number");
		    return;
		}
		if (FIWSystem.setts().getProjectSettingDef(project,"nimprefix","")
		    .length() == 0) {
			System.out.println("project does not use NIMs.");
			return;
		    }
		int newnum=FIWSystem.setts().updateNimNumber(project);
		System.out.println("Updated NIM number from "+
				   FIWSystem.setts().getProjectSettingDef
				   (project, "nextnim","1")
				   +" to "+newnum);
		FIWSystem.setts().saveProject(project, "nextnim", ""+newnum);
	    } catch (NumberFormatException e) {
		System.err.println("Not a number: "+e.getMessage());
	    }
		       
	} else if (args.length >=3 && args.length <=5 &&
		   (args[1].toLowerCase().equals("guiins") ||
		    args[1].toLowerCase().equals("cliins"))) {
	    CliInsert.cliInsertProject(args);
	} else {
	    System.out.println
		("Usage: \n"+
		 "fiw List          to list all the projects\n"+
		 "fiw <project> GuiIns <htl> [<edition>| "+
		 "<from> [<to>]]   to insert a project\n"+
		 "                  (HTL -1 for test inserts)\n"+
		 "                  default for <to> is <from>, "+
		 "for <from> is 1 \n                  (i.e. the "+
		 "next slot, 0 is the current slot)\n"+
		 "fiw <project> CliIns ...  the same w/o gui\n"+
		 "fiw <project> updatenim   update next free nim slot\n"+
		 "fiw guiinsfile/cliinsfile insert a file\n"+
		 "fiw guichecknims/clichecknims\n"+
		 "                          checks NIMs\n"+
		 "fiw cli                   start interactive CLI\n"+
		 "fiw dbrcalc               calculate DBR code\n"+
		 "fiw delete <key> ...      delete keys from local datastore"+
		 "\n"+
		 "fiw mdbrowser Try it (GUI)!\n"+
		 "fiw loadstatus Try it (GUI)!\n"+
		 "fiw genkey <regex>        creates 'nice' ssk pair\n"+
		 "                          (requires Java 1.4+)\n"+
		 "fiw language <locale>     Set language\n"+
		 "fiw help                  to show this text");
	}
    }

    /**
     * Tries to contact the node and print some sensible information
     * about version and/or updating.
     */
    public static FCPConnection doNodeHello() {
	System.out.println("Logging in:");
	FCPConnection result = FIWSystem.getInstance().createFCPConnection();
	String s = result.handshake();
	if (s==null)  {
	    System.err.println ("could not connect to host");
	    System.exit(1);
	}
	System.out.println(s+"\n");
	return result;
    }

    /**
     * Uses reflection to load the SSK nicer and runs it. This is
     * necessary as FIW should work with java prior to 1.4.x and
     * {@link SSKNicer} needs <code>java.util.regex</code>.
     */
    public static void makeNiceSSK(String regex) {
	try {
	    Class clazz = Class.forName("SSKNicer");
	    java.lang.reflect.Method meth =
		clazz.getMethod("makeNiceSSK", new Class[] {String.class});
	    meth.invoke(null, new String[] {regex});
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
