/*
 * Decompiled with CFR 0.152.
 */
package mihi;

import freenet.KeyException;
import freenet.client.Base64;
import freenet.client.Client;
import freenet.client.ClientFactory;
import freenet.client.ClientSVK;
import freenet.client.FreenetURI;
import freenet.client.GetRequest;
import freenet.client.Request;
import freenet.node.Node;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.NullBucket;
import freenet.support.URLDecoder;
import freenet.support.URLEncodedFormatException;
import freenet.support.servlet.HtmlTemplate;
import freenet.support.servlet.TemplateElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetaDataServlet
extends HttpServlet {
    private static final String LOCATION2 = "/servlet/metadata";
    private static final String LOCATION = "/servlet/metadata/";
    private static final String startURL = "SSK@M7yZgrl8gwtAe1xEcR5Xyv4tFsoPAgM/fiw/8//";
    private Node node;
    private ClientFactory clientFactory;
    private BucketFactory bucketFactory;

    public void init() throws ServletException {
        super.init();
        ServletContext servletContext = this.getServletContext();
        this.node = (Node)servletContext.getAttribute("freenet.node.Node");
        this.clientFactory = (ClientFactory)servletContext.getAttribute("freenet.client.ClientFactory");
        this.bucketFactory = (BucketFactory)servletContext.getAttribute("freenet.support.BucketFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string;
        try {
            string = URLDecoder.decode((String)httpServletRequest.getRequestURI());
            if (string.length() < LOCATION2.length() || !string.substring(0, LOCATION2.length()).equals(LOCATION2)) {
                this.makeError(httpServletResponse, string, "Internal error: Does not start with /servlet/metadata/:", "The Metadata servlet does not seem to be installed at /servlet/metadata/. Sorry, cannot do anything about that.");
                return;
            }
        }
        catch (URLEncodedFormatException uRLEncodedFormatException) {
            string = "";
        }
        string = string.length() < LOCATION.length() ? "" : string.substring(LOCATION.length());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = new Date();
        String string2 = httpServletRequest.getParameter("date");
        if (string2 == null) {
            string2 = simpleDateFormat.format(date);
        } else {
            try {
                simpleDateFormat.setLenient(true);
                date = simpleDateFormat.parse(string2);
            }
            catch (ParseException parseException) {
                this.makeError(httpServletResponse, string2, "Incorrect date", "The date you entered is an incorrect date. <a href=\"/servlet/metadata/\">Go back to the Metadata servlet page</a>, or go to the <a href=\"/\">main page</a>");
                return;
            }
        }
        String string3 = httpServletRequest.getParameter("zap");
        if ("yes".equals(string3)) {
            object = new NullBucket();
            this.getData(new FreenetURI(string), 0, (Bucket)object, (Bucket)object, true);
        }
        if ((object = httpServletRequest.getParameter("uri")) != null) {
            httpServletResponse.sendRedirect(LOCATION + (String)object + "?date=" + string2);
        } else if (string.indexOf("//") != -1) {
            httpServletResponse.sendRedirect(LOCATION + string.substring(0, string.indexOf("//")) + "?date=" + string2);
        }
        if (string.length() == 0) {
            try {
                ClientSVK clientSVK = new ClientSVK((Random)Node.randSource);
                String string4 = Base64.encode((byte[])clientSVK.getPrivateKey());
                String string5 = Base64.encode((byte[])clientSVK.getPublicKeyFingerPrint());
                String string6 = Base64.encode((byte[])clientSVK.getCryptoKey());
                this.makeGUI(httpServletResponse, string5, string4, string6, string2);
            }
            catch (KeyException keyException) {
                this.makeError(httpServletResponse, "Exception while creating new key pair", keyException.toString(), "Unexpected error...");
            }
        } else {
            FreenetURI freenetURI = new FreenetURI(string);
            Bucket bucket = this.bucketFactory.makeBucket(-1L);
            Bucket bucket2 = this.bucketFactory.makeBucket(-1L);
            try {
                int n;
                if (!this.getData(freenetURI, 0, bucket, bucket2, false)) {
                    this.makeError(httpServletResponse, string, "Data not found", "The file you requested was not found in your local datastore. <br>You can <a href=\"/servlet/metadata/\">try another address</a>, <a href=\"/" + string + "\">retrieve this file</a> " + "or <a href=\"/\">go to the main page.");
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                InputStream inputStream = bucket.getInputStream();
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    stringBuffer.append(new String(byArray, 0, n));
                }
                String string7 = LOCATION + string + "?date=" + string2 + "&amp;zap=yes";
                this.makeResult(httpServletResponse, string, string7, this.parse(stringBuffer.toString(), string2, date), bucket2.size(), string2);
            }
            finally {
                this.bucketFactory.freeBucket(bucket);
                this.bucketFactory.freeBucket(bucket2);
            }
        }
    }

    private String parse(String string, String string2, Date date) {
        long l = 86400L;
        long l2 = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("DateRedirect.Increment=")) {
                l = Integer.parseInt(string3.substring(23), 16);
                continue;
            }
            if (!string3.startsWith("DateRedirect.Offset=")) continue;
            l2 = Integer.parseInt(string3.substring(20), 16);
        }
        long l3 = date.getTime() / 1000L - l2;
        l3 = l3 / l * l + l2;
        String string4 = Integer.toHexString((int)l3) + "-";
        stringTokenizer = new StringTokenizer(string, "\n");
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            if ((string6 = string6.replace('<', '#')).startsWith("Redirect.Target=")) {
                String string7 = string6.substring(0, 16);
                string5 = string6.substring(16);
                if (string5.startsWith("freenet:")) {
                    string5 = string5.substring(8);
                    string7 = string7 + "freenet:";
                }
                this.appendLink(stringBuffer, string7, string5, string5, string2);
                continue;
            }
            if (string6.startsWith("DateRedirect.Target=")) {
                String string8 = string6.substring(0, 20);
                string5 = string6.substring(20);
                if (string5.startsWith("freenet:")) {
                    string5 = string5.substring(8);
                    string8 = string8 + "freenet:";
                }
                String string9 = "";
                if (string5.startsWith("KSK@")) {
                    string9 = "KSK@" + string4 + string5.substring(4);
                } else if (string5.startsWith("SSK@")) {
                    int n = string5.indexOf("/");
                    string9 = string5.substring(0, n + 1) + string4 + string5.substring(n + 1);
                }
                this.appendLink(stringBuffer, string8, string5, string9, string2);
                continue;
            }
            if (string6.startsWith("DateRedirect.Increment=")) {
                boolean bl;
                boolean bl2 = bl = l == (long)Integer.parseInt(string6.substring(23), 16);
                if (bl) {
                    stringBuffer.append("<font color=\"#008000\">");
                } else {
                    stringBuffer.append("<font color=\"#FF0000\">");
                }
                stringBuffer.append(string6).append("</font><br>\n");
                continue;
            }
            if (string6.startsWith("DateRedirect.Offset=")) {
                boolean bl;
                boolean bl3 = bl = l2 == (long)Integer.parseInt(string6.substring(20), 16);
                if (bl) {
                    stringBuffer.append("<font color=\"#008000\">");
                } else {
                    stringBuffer.append("<font color=\"#FF0000\">");
                }
                stringBuffer.append(string6).append("</font><br>\n");
                continue;
            }
            if (string6.startsWith("Name=")) {
                stringBuffer.append("<b>").append(string6).append("</b><br>\n");
                continue;
            }
            if (string6.indexOf("CHK@") != -1) {
                int n = string6.indexOf("CHK@");
                this.appendLink(stringBuffer, string6.substring(0, n), string6.substring(n), string6.substring(n), string2);
                continue;
            }
            if (string6.indexOf("=") == -1 && !string6.startsWith("End")) {
                stringBuffer.append("<font size=-3>&nbsp;<br></font>").append(string6).append("<br>\n");
                continue;
            }
            stringBuffer.append(string6).append("<br>\n");
        }
        return stringBuffer.toString();
    }

    private void appendLink(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        stringBuffer.append(string).append("<a href=\"").append(LOCATION).append(string3).append("?date=").append(string4).append("\">").append(string2).append("</a><br>\n");
    }

    private void makeResult(HttpServletResponse httpServletResponse, String string, String string2, String string3, long l, String string4) throws IOException {
        String string5 = "<tt>" + string3 + "</tt><hr>Data length: " + l + " [<a href=\"/" + string + "\">View data</a>] " + "[<a href=\"" + string2 + "\">Delete locally</a>]<hr>" + "<form method=\"GET\">Date for <tt>DateRedirect</tt>s:" + " <input type=\"text\" name=\"date\" value=\"" + string4 + "\" size=10><input type=\"submit\" value=\"Change\"></form>" + "</html>";
        this.fillTemplate(httpServletResponse, string5, "Metadata viewer", "Metadata of " + string);
    }

    private void fillTemplate(HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        HtmlTemplate htmlTemplate = HtmlTemplate.createTemplate((String)"SimplePage.html");
        HtmlTemplate htmlTemplate2 = HtmlTemplate.createTemplate((String)"aqua/titleBox.tpl");
        htmlTemplate.set("TITLE", string2);
        htmlTemplate2.set("TITLE", string3);
        htmlTemplate2.set("CONTENT", string);
        htmlTemplate.set("BODY", (TemplateElement)htmlTemplate2);
        htmlTemplate.toHtml(printWriter);
        printWriter.close();
    }

    private void makeError(HttpServletResponse httpServletResponse, String string, String string2, String string3) throws IOException {
        String string4 = string2 + ": " + string;
        this.fillTemplate(httpServletResponse, string3, "Metadata viewer - error", string4);
    }

    private void makeGUI(HttpServletResponse httpServletResponse, String string, String string2, String string3, String string4) throws IOException {
        String string5 = "<form method=\"GET\">URI: <input type=\"text\" size=80 name=\"uri\" value=\"SSK@M7yZgrl8gwtAe1xEcR5Xyv4tFsoPAgM/fiw/8//\"><br>Date: <input type=\"text\" size=10 name=\"date\" value=\"" + string4 + "\"><input type=\"submit\" value=\"Request\"></form><hr>" + "<h2>Key Pair</h2>" + "A new SSK key pair is:<br>" + "public key: <b>SSK@" + string + "PAgM," + string3 + "/</b><br>private key: <b>SSK@" + string2 + "," + string3 + "/</b>";
        this.fillTemplate(httpServletResponse, string5, "Metadata servlet", "Metadata servlet");
    }

    private boolean getData(FreenetURI freenetURI, int n, Bucket bucket, Bucket bucket2, boolean bl) throws IOException {
        GetRequest getRequest = new GetRequest(n, freenetURI, bucket, bucket2, bl);
        try {
            Client client = this.clientFactory.getClient((Request)getRequest);
            int n2 = client.blockingRun();
            return n2 == 3;
        }
        catch (KeyException keyException) {
            return false;
        }
    }
}

