/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.FileUtil;
import fiw.core.I18n;
import fiw.core.ProjectKnower;
import fiw.gui.NoWizard;
import fiw.gui.awt.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Wizard
extends Frame
implements ActionListener,
ProjectKnower {
    Panel steps;
    CardLayout stepsLayout;
    TextArea desc;
    int current = 0;
    WizardPanel[] stepPanel;
    public static final Image fiwIcon = Toolkit.getDefaultToolkit().createImage((class$fiw$Main == null ? (class$fiw$Main = Wizard.class$("fiw.Main")) : class$fiw$Main).getResource("/res/icon.gif"));
    int projectnum = -1;
    private boolean advancedOpen = false;
    static /* synthetic */ Class class$fiw$Main;

    public Wizard() {
        super(I18n.format("WindowCaption", "0.08"));
        this.setBackground(Color.lightGray);
        this.setIconImage(fiwIcon);
        Panel p = new Panel(new GridLayout(1, 2));
        this.add("Center", p);
        Panel p2 = new Panel(new BorderLayout());
        p.add(p2);
        this.desc = new TextArea("", 25, 40, 1);
        p2.add("Center", this.desc);
        this.desc.setEditable(false);
        p2.add("East", new Panel(){

            public Dimension getPreferredSize() {
                return new Dimension(12, 12);
            }

            public void paint(Graphics g) {
                int w = this.getWidth();
                int h = this.getHeight();
                g.fillRect(w / 2 - 1, 0, 2, h);
            }
        });
        this.stepsLayout = new CardLayout();
        this.steps = new Panel(this.stepsLayout);
        p.add(this.steps);
        p = new Panel(new GridLayout(1, 3));
        this.add("South", p);
        Button b = new Button(I18n.get("WizardBack"));
        p.add(b);
        b.setActionCommand("Back");
        b.addActionListener(this);
        b = new Button(I18n.get("WizardNext"));
        p.add(b);
        b.setActionCommand("Next");
        b.addActionListener(this);
        b = new Button(I18n.get("WizardQuit"));
        p.add(b);
        b.setActionCommand("Quit");
        b.addActionListener(this);
        this.stepPanel = new WizardPanel[WizardPanel.getCount()];
        for (int i = 0; i < this.stepPanel.length; ++i) {
            this.stepPanel[i] = WizardPanel.getPanel(i, this);
            this.steps.add("" + i, this.stepPanel[i]);
        }
        this.stepsLayout.show(this.steps, "" + this.current);
        this.showText(this.current);
        this.stepPanel[this.current].refresh();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Wizard.this.quit();
            }
        });
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals("Quit")) {
            this.quit();
        } else if (cmd.equals("Next")) {
            this.current = this.stepPanel[this.current].getNext();
            if (this.current == -1) {
                this.dispose();
            } else {
                this.stepsLayout.show(this.steps, "" + this.current);
                this.stepPanel[this.current].refresh();
                this.showText(this.current);
            }
        } else if (cmd.equals("Back")) {
            this.current = this.stepPanel[this.current].getPrev();
            if (this.current == -1) {
                this.dispose();
                new NoWizard();
            } else {
                this.stepsLayout.show(this.steps, "" + this.current);
                this.showText(this.current);
            }
        } else {
            System.out.println(cmd);
        }
    }

    void quit() {
        System.exit(0);
    }

    void showText(int no) {
        this.desc.setText(FileUtil.getWizardDesc(no));
    }

    public int getProjectNumber() {
        return this.projectnum;
    }

    public void setProjectNumber(int newNumber) {
        this.projectnum = newNumber;
    }

    public void setAdvancedOpen(boolean advOpen) {
        this.advancedOpen = advOpen;
    }

    public boolean isAdvancedOpen() {
        return this.advancedOpen;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

