/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.GUIHelper;
import fiw.core.I18n;
import fiw.core.option.AbstractOptions;
import fiw.gui.awt.GlobalOptionWizardPanel;
import fiw.gui.awt.Wizard;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ServerPortWP
extends GlobalOptionWizardPanel
implements ActionListener {
    boolean okay = false;
    Checkbox advanced;

    public ServerPortWP(Wizard w) {
        super(0, w);
        Button b = new Button(I18n.get("CheckServer"));
        this.add((Component)b, gbcRight);
        b.addActionListener(this);
        this.advanced = new Checkbox(I18n.get("ShowAdvanced"));
        this.add((Component)this.advanced, gbcRight);
        this.errors = new TextArea("", 10, 10, 1);
        this.add((Component)this.errors, gbcBottom);
        this.errors.setEditable(false);
    }

    public int getNext() {
        if (!this.okay) {
            this.doCheck();
        }
        if (!this.okay) {
            return 0;
        }
        this.parent.setAdvancedOpen(this.advanced.getState());
        if (this.advanced.getState()) {
            return 1;
        }
        return 2;
    }

    public int getPrev() {
        return -1;
    }

    public void refresh() {
        super.refresh();
        this.doCheck();
    }

    public void actionPerformed(ActionEvent evt) {
        this.doCheck();
    }

    void doCheck() {
        int p;
        AbstractOptions opts = this.getOptionsList();
        this.okay = false;
        for (int i = 0; i < opts.getSettings().length; ++i) {
            if (this.flushOption(i, opts.getSettings())) continue;
            return;
        }
        try {
            p = Integer.parseInt(opts.getOption("fcp.port").getValue());
        }
        catch (NumberFormatException e) {
            this.errors.setText(I18n.format("ErrInvalidPort", e.getMessage()));
            return;
        }
        String h = opts.getOption("fcp.host").getValue();
        String s = GUIHelper.getInstance().handshake(h, p);
        if (s == null) {
            this.errors.setText(I18n.get("ErrNoConn"));
        } else {
            this.errors.setText(s);
            this.okay = true;
        }
    }
}

